/* 
 * sigaction.c 
 *
 * Виводить відповідні повідомлення, коли отримує сигнал SIGINT
 * або SIGTERM.
 * Ілюструє порядок організації асинхронної обробки сигналів
 * (функція sigaction()).
 *
 */

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


/* Обробник сигналів SIGINT, SIGTERM. */
void sig_handler(int signo)
{
        /* Використовується функція write(), оскільки функції більш
           високого рівня не є безпечними в контексті асинхронної
           обробки сигналів. */
        write(STDOUT_FILENO, "Отримано сигнал", 29);
        switch (signo) {
        case SIGINT:
                write(STDOUT_FILENO, " SIGINT", 7);
                break;
        case SIGTERM:
                write(STDOUT_FILENO, " SIGTERM", 8);
                break;
        }
        write(STDOUT_FILENO, ".\n", 2);
}

int main()
{
        struct sigaction act;

        printf("Привіт, мій PID дорівнює %d.\n", (int) getpid());

        /* Визначає нову диспозицію для сигналів SIGINT, SIGTERM. */
        act.sa_handler = sig_handler;
        sigemptyset(&act.sa_mask);
        act.sa_flags = 0;
        if ((sigaction(SIGINT, &act, NULL) != 0)
                || (sigaction(SIGTERM, &act, NULL) != 0)) {
                fprintf(stderr, "Помилка при спробі встановити диспозицію"
                                " сигналу SIGINT або SIGTERM: %s\n",
                                                        strerror(errno));
                exit(EXIT_FAILURE);
        }

        while (1)
                pause();

        exit(EXIT_SUCCESS);
}
